
/* Copyright (c) 1999, 2004, Oracle. All rights reserved.  */

import java.sql.Connection;
import java.sql.DriverManager;
import oracle.jdbc.OracleDriver;

public class TestRationalO
{

  public static void main(String[] args) throws java.sql.SQLException
  {
    DriverManager.registerDriver(new OracleDriver());
    Connection conn  = DriverManager.getConnection("jdbc:oracle:oci8:@", "scott","tiger");

    if (conn == null)
    {
       System.err.println("Can't connect!");
       return;
    }

    Integer n = new Integer(5);
    Integer d = new Integer(10);
    RationalO r = new RationalO(conn);
    r.setNumerator(n);
    r.setDenominator(d);

    Integer g = r.gcd(n, d);
    System.out.println("gcd: " + g);

    Float f = r.toreal();
    System.out.println("real value: " + f);

    RationalO s = r.plus(r); 
    System.out.println("sum: " + s.getNumerator() + "/" + 
                                 s.getDenominator());

    s = s.normalize();
    System.out.println("sum: " + s.getNumerator() + "/" + 
                                 s.getDenominator());
  } 
}
